// config: norepeat

#include "GetObjects.js"
#include "GetPoint.js"

function DoExplodeMove()
{
	var objectpicker = moi.ui.createObjectPicker();
	if ( !GetObjects( objectpicker ) )
		return;
		
	moi.ui.beginUIUpdate();
	moi.ui.hideUI( 'SelectPrompt' );
	moi.ui.showUI( 'OptionsPrompt' );
	moi.ui.showUI( 'Options' );
	moi.ui.endUIUpdate();

	var factory = moi.command.createFactory( 'explodemove' );
	factory.setInput( 0, objectpicker.objects );
	
	moi.ui.bindUIToInput( 'scaleinput', 'value', factory.getInput(1) );

	var commandDialog = moi.ui.commandDialog;
	
	while ( 1 )
	{
		if ( !commandDialog.waitForEvent() )
			return;
			
		if ( commandDialog.event == 'done' )
			break;
			
		if ( commandDialog.event == 'pickorigin' )
		{
			moi.ui.beginUIUpdate();
			moi.ui.hideUI( 'OptionsPrompt' );
			moi.ui.hideUI( 'Options' );
			moi.ui.hideUI( 'done' );
			moi.ui.showUI( 'PickOriginPrompt' );
			moi.ui.endUIUpdate();
			
			var prevpt = null;
			try { prevpt = factory.getInput(2).getValue(); } catch (e) { }
			
			var pointpicker = moi.ui.createPointPicker();
			pointpicker.bindResultPt( factory.getInput(2) );
			pointpicker.allowNestedCancel();
			if ( !GetPoint( pointpicker ) )
			{
				factory.setInput( 2, prevpt );
				factory.update();
			}
				
			moi.ui.clearPickedPoints();
							
			moi.ui.beginUIUpdate();
			moi.ui.showUI( 'OptionsPrompt' );
			moi.ui.showUI( 'Options' );
			moi.ui.showUI( 'done' );
			moi.ui.hideUI( 'PickOriginPrompt' );
			moi.ui.endUIUpdate();
		}
	}
	
	factory.commit();
}

DoExplodeMove();
